<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\UserController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\MaintenanceController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });


RateLimiter::for('login', function (Request $request) {
    return Limit::perMinute(5)->by($request->email.$request->ip());
});


Route::post('login', [UserController::class, 'login'])->middleware('check.maintenance');
// Route::post('login', [UserController::class, 'login']);
Route::post('login/token', [UserController::class, 'loginWithToken'])->middleware('check.maintenance');
Route::post('forgot-password', [UserController::class, 'forgotPassword']);
Route::post('reset-password', [UserController::class, 'resetPassword']);
Route::post('register', [UserController::class, 'register']);
Route::get('get-csrf-token', [UserController::class, 'getCsrfToken']);
Route::post('batch-import', [UserController::class, 'batchImport']);
Route::post('pull-leave-balances', [LeaveController::class, 'pullLeaveBalances']);


Route::middleware('auth:sanctum')->group(function () {
    Route::post('toggle-maintenance', [MaintenanceController::class, 'toggleMaintenanceMode']);
    Route::get('get-maintenance', [MaintenanceController::class, 'getMaintenanceMode']);

    Route::middleware('check.maintenance')->group(function () {
        Route::get('users', [UserController::class, 'index']);
        Route::get('logout', [UserController::class, 'logout']);
        Route::get('users/{id}', [UserController::class, 'show']);
        Route::put('usersupdate/{id}', [UserController::class, 'update']);
        Route::delete('usersdelete/{id}', [UserController::class, 'destroy']);
        Route::get('employees', [UserController::class, 'getEmployees']);
        // Route::post('password/reset/request', [UserController::class, 'loginWithToken']);
        // Route::post('password/reset', [UserController::class, 'loginWithToken']);
        // Route::post('logout', [UserController::class, 'logout']);
    
    
        Route::post('send-email', [LeaveController::class, 'sendLeaveRequestEmail']);
        Route::get('all-leave-taken', [LeaveController::class, 'getAllLeaveTaken']);
        Route::get('approvee-leave-taken/{id}', [LeaveController::class, 'getApproveeLeaveTaken']);
        Route::put('action-leave-taken', [LeaveController::class, 'actionLeaveTaken']);
        Route::get('leave-taken/{id}', [LeaveController::class, 'getLeaveTaken']);
        Route::post('apply-leave', [LeaveController::class, 'applyLeaveTaken']);
        Route::get('leave-groups', [LeaveController::class, 'getLeaveGroups']);
        Route::get('public-holidays', [LeaveController::class, 'getPublicHolidays']);
        
        Route::middleware(['clear.tokens'])->group(function () {
            Route::put('edit-employee', [LeaveController::class, 'editEmployee']);
            Route::post('add-leave-group', [LeaveController::class, 'addLeaveGroup']);
            Route::put('edit-leave-group', [LeaveController::class, 'editLeaveGroup']);
            Route::post('add-public-holiday', [LeaveController::class, 'addPublicHoliday']);
            Route::put('edit-public-holiday', [LeaveController::class, 'editPublicHoliday']);
            Route::put('edit-annual-leave-entitlement', [LeaveController::class, 'editAnnualLeaveEntitlement']);
            Route::put('edit-linked-account', [LeaveController::class, 'editLinkedAccount']);
            Route::put('edit-payroll-setting', [LeaveController::class, 'editPayrollSetting']);
            Route::post('add-leave-type', [LeaveController::class, 'addLeaveType']);
            Route::put('edit-leave-type', [LeaveController::class, 'editLeaveType']);
            Route::post('set-leave-balances', [LeaveController::class, 'setLeaveBalances']);
            Route::post('accrual-run', [LeaveController::class, 'accrualRun']);
            Route::put('edit-leave', [LeaveController::class, 'editLeaveTaken']);
            Route::post('restore-uploaded-database', [FileController::class, 'restoreDBFromUpload']);
            Route::post('restore-database', [FileController::class, 'restoreDB']);
            Route::delete('delete-leave-record', [LeaveController::class, 'deleteLeaveRecord']);
        });
    
        Route::delete('delete-leave-taken', [LeaveController::class, 'deleteLeaveTaken']);


        Route::get('leave-types', [LeaveController::class, 'getLeaveTypes']);
        Route::get('leave-balances', [LeaveController::class, 'getLeaveBalances']);
        Route::get('get-user-leave-balances/{id}', [LeaveController::class, 'getUserLeaveBalances']);
        Route::get('accrual-runs', [LeaveController::class, 'getAccrualRuns']);
        Route::get('leave-planner-data/{id}', [LeaveController::class, 'getLeavePlannerData']);
        
        Route::get('password-complexity', [SettingsController::class, 'show']);
        Route::post('password-complexity', [SettingsController::class, 'store']);
    
        Route::get('db-backups', [FileController::class, 'getAvailableBackups']);
        Route::get('db-backups/download/{filename}', [FileController::class, 'downloadBackup']);
        Route::post('backup-database', [FileController::class, 'backupDB']);
    });
});





