<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PasswordComplexity;

class SettingsController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'min_length' => 'required|integer|min:1',
            'include_numbers' => 'required|boolean',
            'include_special_chars' => 'required|boolean',
            'include_uppercase' => 'required|boolean',
        ]);
    
        // Assuming a single row for simplicity; adjust as needed.
        PasswordComplexity::updateOrCreate(['id' => 1], $data);
    
        return response()->json(['message' => 'Password complexity updated']);
    }
    
    public function show()
    {
        // Retrieve settings; assuming a single row.
        $settings = PasswordComplexity::find(1);
    
        return response()->json($settings);
    }
}

