<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Artisan;

class FileController extends Controller
{
    public function getAvailableBackups()
    {
        // Path to the backups directory in the main directory of the Laravel app
        $directory = base_path('storage/app/db_backups'); // 'base_path' points to the root of the Laravel application
        $files = File::files($directory);

        $fileNames = [];
        $id = 1;
        foreach ($files as $file) {
            $fileNames[] = array(
                'id' => $id,
                'filename' => $file->getFilename(),
            );

            $id++;
        }

        return response()->json($fileNames, 200);
    }

    public function downloadBackup($filename)
    {
        // Path to the backups directory in the main directory of the Laravel app
        $filePath = base_path('storage/app/db_backups/' . $filename);

        if (File::exists($filePath)) {
            return Response::download($filePath, $filename, [
                'Content-Length: '. File::size($filePath)
            ]);
        } else {
            return response()->json(['message' => 'File not found.'], 404);
        }
    }

    public function backupDB()
    {
        try {
            Artisan::call('backup:database');

            $backups = $this->getAvailableBackups();
            return response()->json([
                'message' => 'Backup successful!',
                'backups' => $backups->original
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Backup failed!', 'error' => $e->getMessage()], 500);
        }
    }

    public function restoreDB(Request $request)
    {
        $filename = $request->input('filename');
        try {
            Artisan::call('restore:database', [
                'filename' => $filename
            ]);
            return response()->json(['message' => 'Restore successful!'], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Restore failed!', 'error' => $e->getMessage()], 500);
        }
    }

    public function restoreDBFromUpload(Request $request)
    {
        if ($request->hasFile('uploaded_backup')) {
            $file = $request->file('uploaded_backup');
            $filename = $file->getClientOriginalName();
            $path = $file->storeAs('uploaded_backups', $filename);

            // Run the restore command
            try {
                Artisan::call('restore:database', [
                    'filename' => $filename
                ]);
                return response()->json(['message' => 'Restore successful!'], 200);
            } catch (\Exception $e) {
                return response()->json(['message' => 'Restore failed!', 'error' => $e->getMessage()], 500);
            }
        }

        return response()->json(['message' => 'No file uploaded!'], 400);
    }
}
