<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LeaveTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $public_holidays_array = json_encode(array(
            "New Year's Day" => 0,
            "Robert Mugabe National Youth Day" => 0,
            "Good Friday" => 0,
            "Easter Saturday" => 0,
            "Easter Sunday" => 0,
            "Easter Monday" => 0,
            "Independence Day" => 0,
            "Worker's Day" => 0,
            "Africa Day" => 0,
            "Heroes' Day" => 0,
            "Defence Forces Day" => 0,
            "Unity Day" => 0,
            "Christmas Day" => 0,
            "Boxing Day" => 0,
        ));

        DB::table('leave_types')->insert([
            [
                'name' => 'ANNUAL', 
                'accrual_type' => 1,
                'accrual_days' => 2.5,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'COMPASSIONATE/FAMILY/PATERNITY', 
                'accrual_type' => 12,
                'accrual_days' => 12,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "hierachichal",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'MATERNITY', 
                'accrual_type' => 12,
                'accrual_days' => 180,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'SICK', 
                'accrual_type' => 12,
                'accrual_days' => 90,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'STUDY', 
                'accrual_type' => 12,
                'accrual_days' => 5,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'UNPAID ANNUAL LEAVE', 
                'accrual_type' => 12,
                'accrual_days' => 0,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
        ]);

        DB::table('payroll_settings')->insert([
            [
                'name' => 'ANNUAL', 
                'accrual_type' => 1,
                'accrual_days' => 2.5,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'COMPASSIONATE/FAMILY/PATERNITY', 
                'accrual_type' => 12,
                'accrual_days' => 12,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "hierachichal",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'MATERNITY', 
                'accrual_type' => 12,
                'accrual_days' => 180,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'SICK', 
                'accrual_type' => 12,
                'accrual_days' => 90,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 1,
                'sunday' => 1,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'STUDY', 
                'accrual_type' => 12,
                'accrual_days' => 5,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
            [
                'name' => 'UNPAID ANNUAL LEAVE', 
                'accrual_type' => 12,
                'accrual_days' => 0,
                'start_time' => '08:00',
                'end_time' => '17:00',
                'leave_approvers' => json_encode([0]),
                'leave_approvers_type' => "any",
                'monday' => 1,
                'tuesday' => 1,
                'wednesday' => 1,
                'thursday' => 1,
                'friday' => 1,
                'saturday' => 0,
                'sunday' => 0,
                'public_holidays' => $public_holidays_array
            ],
        ]);


    }
}
