<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;


class LeaveBalancesSeeder extends Seeder
{
    private $employee_number;

    public function __construct($employee)
    {
        $this->employee = $employee;
    }

    public function run(): void
    {
        $employee = $this->employee;

        $balances = [
            "1" => [
                "pending" => 0,
                "available" => 2.5
            ],
            "2" => [
                "pending" => 0,
                "available" => 12
            ],
            "4" => [
                "pending" => 0,
                "available" => 90
            ],
            "5" => [
                "pending" => 0,
                "available" => 5
            ],
            "6" => [
                "pending" => 0,
                "available" => 0
            ],
        ];

        if ($employee->gender === "F") {
            $entry = [
                "pending" => 0,
                "available" => 180
            ];

            $balances["3"] = $entry;
        }

        // for ($i = 0; $i < 10; $i++) {
        DB::table('leave_balances')->insert([
            'employee_number' => $employee->employee_number,
            'balances' => json_encode($balances)
        ]);
        // }
    }
}
