<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cp_parm_codes', function (Blueprint $table) {
            $table->id();
            $table->string("AdjustFlag")->nullable();
            $table->string("CodeName")->nullable();
            $table->string("CodeType")->nullable();
            $table->string("ConsolArnFlag")->nullable();
            $table->integer("ConsolCode")->nullable();
            $table->string("Limit")->nullable();
            $table->string("ManualDisplayInd")->nullable();
            $table->unsignedBigInteger("OrdinalNo")->unique();
            $table->string("Payroll")->nullable();
            $table->string("ProRataInd")->nullable();
            $table->string("QmfDisplayInd")->nullable();
            $table->string("TaxIncAsn")->nullable();
            $table->string("TaxType")->nullable();
            $table->string("currency")->nullable();
            $table->string("TamsColumn")->nullable();
            $table->string("Journal")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cp_parm_codes');
    }
};
