<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('password_complexities', function (Blueprint $table) {
            $table->id();
            $table->integer('min_length')->default(8);
            $table->boolean('include_numbers')->default(false);
            $table->boolean('include_special_chars')->default(false);
            $table->boolean('include_uppercase')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('password_complexities');
    }
};
