<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_information', function (Blueprint $table) {
            $table->id();
            // $table->unsignedBigInteger('employee_number')->primary();
            $table->foreignId('employee_number')->constrained('users', 'employee_number');
            $table->enum('gender', ['F', 'M'])->default('F');
            $table->string('payroll_number')->nullable();
            $table->string('cost_codes')->nullable();
            $table->string('occupation')->nullable();
            $table->string('pay_point')->nullable();
            $table->string('title')->nullable();
            $table->string('birth_date')->nullable();
            $table->string('engage_date')->nullable();
            $table->string('discharge_date')->nullable();
            $table->boolean('stop_accrual')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_information');
    }
};
