<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leave_takens', function (Blueprint $table) {
            $table->id();
            // $table->string('user_id')->nullable();
            // $table->foreignId('employee_number')->references('employee_number')->on('users')->nullable();#->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('employee_number')->constrained('users', 'employee_number')->nullable();#->onDelete('cascade')->onUpdate('cascade');
            // $table->string('leave_type_id')->nullable();
            $table->foreignId('leave_type_id')->constrained('leave_types')->nullable();
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->string('duration')->nullable();
            $table->string('application_reason')->nullable();
            $table->string('status')->nullable();
            $table->json('actioned_by')->nullable();
            $table->string('action_reason')->nullable();
            $table->string('attachment')->nullable();
            $table->string('run_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leave_takens');
    }
};
