<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leave_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->float('accrual_type');
            $table->float('accrual_days');
            $table->string('start_time');
            $table->string('end_time');
            $table->json('leave_approvers')->nullable();
            $table->string('leave_approvers_type')->nullable();
            $table->boolean('monday')->nullable()->default(0);
            $table->boolean('tuesday')->nullable()->default(0);
            $table->boolean('wednesday')->nullable()->default(0);
            $table->boolean('thursday')->nullable()->default(0);
            $table->boolean('friday')->nullable()->default(0);
            $table->boolean('saturday')->nullable()->default(0);
            $table->boolean('sunday')->nullable()->default(0);
            $table->json('public_holidays')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leave_types');
    }
};
