<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        // return false;
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

    public function rules(): array
    {
        if(request()->isMethod('post')) {
            return [
                'employee_number' => 'required|integer',
                'name' => 'required|string|max:258',
                'email' => 'required|string',
                'password' => 'string',
                'payroll_number' => 'required|integer',
                'leave_policy_id' => 'integer',
                'access_level' => 'integer',
                'leave_approvers' => '|string',
                'leave_approvers_type' => '|string'
            ];
        } else {
            return [
                'name' => 'required|string|max:258',
                'email' => 'required|string',
                'password' => 'required|string'
            ];
        }
    }
     
    public function messages()
    {
        if(request()->isMethod('post')) {
            return [
                'employee_number.required' => 'Employee Number is required',
                'name.required' => 'Name is required!',
                'email.required' => 'Email is required!',
                'payroll_number.required' => 'Payroll Number is required'
                
            ];
        } else {
            return [
                'name.required' => 'Name is required!',
                'email.required' => 'email is required!',
                'password.required' => 'password is required!'
            ];   
        }
    }
}
