<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Laravel\Sanctum\PersonalAccessToken;

class ClearPersonalAccessTokens
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Continue to the next middleware/request
        $response = $next($request);

        // Perform token clearing after response is sent to the client
        if ($response->getStatusCode() === 200) { 
            if (Auth::check()) {
                $user = Auth::user();
                // Get the last token for the authenticated user
                $lastToken = $user->tokens()->latest()->first();

                if ($lastToken) {
                    // Delete all tokens except the last one
                    PersonalAccessToken::where('id', '!=', $lastToken->id)
                        ->delete();
                }
            }
        }

        return $response;
        // return $next($request);
    }
}
