<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $routeName = $request->route()->uri;
        $response = $next($request);
        // return $response;

        $maintenanceMode = Cache::get('maintenance_mode', false);
        $allowedUserId = Cache::get('maintenance_user_id', null);
        
        if ($maintenanceMode) {
            if ($routeName == 'api/login') {
                $user_id = $response->original["employee"]["id"];
                if ($user_id != $allowedUserId) {
                    Auth::logout();
                    return response()->json(['message' => 'The system is currently under maintenance. Please try again later.'], 503);
                }
            } else{
                $user = Auth::user();
                if ($user && $user->id != $allowedUserId) {
                    Auth::logout();
                    return response()->json(['message' => 'The system is currently under maintenance. Please try again later.'], 503);
                }
            }

        }

        return $response;
    }
}
