<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class RestoreDatabase extends Command
{
    protected $signature = 'restore:database {filename}';
    protected $description = 'Restore the MySQL database from a backup file';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $filename = $this->argument('filename');
        $database = config('database.connections.mysql.database');
        $username = config('database.connections.mysql.username');
        $password = config('database.connections.mysql.password');
        $host = config('database.connections.mysql.host');
        $backupPath = storage_path('app/db_backups/' . $filename);

        if (!file_exists($backupPath)) {
            $this->error('Backup file does not exist!');
            return 1;
        }

        $command = "mysql --user={$username} --password='{$password}' --host={$host} {$database} < {$backupPath}";

        $result = null;
        $output = null;

        exec($command, $output, $result);

        if ($result === 0) {
            $this->info('Restore successful!');
            return 0;
        } else {
            $this->error('Restore failed!');
            return 1;
        }
    }
}

